<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of StringUtilsTest
 *
 * @author majkel
 */
class StringUtilsTest extends PHPUnit_Framework_TestCase
{
	/**
	 * @dataProvider dataProviderTestNumberUnitWorld
	 */
	public function testNumberUnitWorld($number, $unitIndex, $units=null)
	{
		static $_units = array('metr', 'metry', 'metrów');
		if (empty($units)) $units = $_units;

		$this->assertEquals(
			StringUtils::numberUnitWorld($number, $units),
			$units[$unitIndex]
		);
	}

	public function dataProviderTestNumberUnitWorld()
	{
		static $data = array(
			array(0, 2),
			array(1, 0),
			array(2, 1),
			array(3, 1),
			array(4, 1),
			array(5, 2),
			array(6, 2),
			array(10, 2),
			array(11, 2),
			array(12, 2),
			array(13, 2),
			array(14, 2),
			array(15, 2),
			array(16, 2),
			array(30, 2),
			array(31, 2),
			array(32, 1),
			array(33, 1),
			array(34, 1),
			array(35, 2),
			array(36, 2),
			array(-3, 1),
			array(-1, 0),
			array(-88, 2),
		);
		return $data;
	}

	/**
	 * @dataProvider dataProviderTestNumberToWorld
	 */
	public function testNumberToWorld($number, $result)
	{
		$this->assertEquals(StringUtils::numberToWorld($number), $result);
	}

	public function dataProviderTestNumberToWorld()
	{
		return array(
			array(0, 'zero'),
			array(1, 'jeden'),
			array(2, 'dwa'),
			array(3, 'trzy'),
			array(10, 'dziesięć'),
			array(11, 'jedenaście'),
			array(12, 'dwanaście'),
			array(73, 'siedemdziesiąt trzy'),
			array(101, 'sto jeden'),
			array(102, 'sto dwa'),
			array(100, 'sto'),
			array(300, 'trzysta'),
			array(800, 'osiemset'),
			array(1001, 'tysiąc jeden'),
			array(1002, 'tysiąc dwa'),
			array(101101101, 'sto jeden milionów sto jeden tysięcy sto jeden'),
			array(2000, 'dwa tysiące'),
			array(1000000, 'milion'),
			array(1000000000, 'miliard'),
			array(103, 'sto trzy'),
			array(123, 'sto dwadzieścia trzy'),
			array(208, 'dwieście osiem'),
			array(1000, 'tysiąc'),
			array(2534, 'dwa tysiące pięćset trzydzieści cztery'),
			array(108534, 'sto osiem tysięcy pięćset trzydzieści cztery'),
			array(534108534, 'pięćset trzydzieści cztery miliony sto osiem tysięcy pięćset trzydzieści cztery'),
			array(-18, 'minus osiemnaście'),
			array(-202, 'minus dwieście dwa'),
			array(-1, 'minus jeden'),
			array(22.7, 'dwadzieścia dwa'),
			array('34', 'trzydzieści cztery'),
			array('07', 'siedem'),
		);
	}

	/**
	 * @dataProvider dataProviderTestC
	 */
	public function testC($input, $output, $plec)
	{
		if ($plec)
			Yii::app()->user->setState('plec', $plec);
		$this->assertEquals(StringUtils::c($input), $output);
	}

	public function dataProviderTestC()
	{
		return array(
			array('', '', 'k'),
			array('Ala ma kota a kot ma Alę.', 'Ala ma kota a kot ma Alę.', 'k'),
			array('uzytkownk jest [kobietą]', 'uzytkownk jest [kobietą]', 'm'),
			array('uzytkownk jest [kobietą/mężczyną]', 'uzytkownk jest kobietą', 'k'),
			array('uzytkownk jest [kobietą\mężczyną]', 'uzytkownk jest kobietą', 'k'),
			array('uzytkownk jest [kobietą|mężczyną]', 'uzytkownk jest kobietą', 'k'),
			array('uzytkownk jest [kobietą/mężczyną]', 'uzytkownk jest mężczyną', 'm'),
			array('uzytkownk jest [kobietą\mężczyną]', 'uzytkownk jest mężczyną', 'm'),
			array('uzytkownk jest [kobietą|mężczyną]', 'uzytkownk jest mężczyną', 'm'),
			array('uzytkownk jest [ ko?>bi$etą | mężczyną ]', 'uzytkownk jest  ko?>bi$etą ', 'k'),
			array('uzytkownk jest [ ko?>bi$etą | mężczyną ]', 'uzytkownk jest  ko?>bi$etą ', 'k'),
			array('uzytkownk jest [ ko?>bi$etą | mężczyną ]', 'uzytkownk jest  ko?>bi$etą ', 'k'),
			array("uzytkownk jest [ \t\n | mężczyną ]", "uzytkownk jest  \t\n ", 'k'),
			array("uzytkownk jest [ \t\n | mężczyną ] dfsf dsf [a/b] sd fdsf [ c / d ] sdf ds sd",
				"uzytkownk jest  \t\n  dfsf dsf a sd fdsf  c  sdf ds sd", 'k'),
		);
	}
}
